# -*- coding: utf-8 -*-

from random import randrange

WHITE   = 0
BLACK   = 1

side = WHITE
countMoves = 1

maxDepth = 3 # глубина анализа maxDepth полуходов

PAWN    = 1
HORSE   = 2
BISHOP  = 3
ROOK    = 4
QUEEN   = 5
KING    = 6
FLAG    = 7

EMPTY   = 8
OUT     = 9

# веса фигур
W_PAWN    = 100
W_HORSE   = 4*W_PAWN+PAWN/2
W_BISHOP  = 4*W_PAWN+PAWN/2
W_ROOK    = 6*W_PAWN
W_QUEEN   = 12*W_PAWN
W_KING    = 3*W_PAWN
W_FLAG    = (W_PAWN*12+W_HORSE*2+W_BISHOP*2+W_ROOK*2+W_QUEEN+W_KING)*10
INFINITY  = 10000*W_PAWN

# для вычисления веса фигуры
WFIG = (0,W_PAWN,W_HORSE,W_BISHOP,W_ROOK,W_QUEEN,W_KING,W_FLAG)

# приращения для фигур
U   = -15 # вверх
D   =  15 # вниз
L   = -1  # влево
T   =  1  # вправо
# диагонали
LU  = L+U
TU  = T+U
LD  = L+D
TD  = T+D

# списки приращений
dPAWN   = ((U, LU, TU), # белые пешки
           (D, LD, TD)) # чёрные пешки
dHORSE  = (LU+U, LU+L, TU+U, TU+T, LD+D, LD+L, TD+D, TD+T, LU, TU, LD, TD)
dBISHOP = (LU, TU, LD, TD)
dROOK   = (U, D, L, T)
dQUEEN  = dROOK + dBISHOP
dKING   = dQUEEN
dFLAG   = ()
vectDisp = (0,dPAWN,dHORSE,dBISHOP,dROOK,dQUEEN,dKING,dFLAG)

# фигуры
wP = (WHITE,PAWN)
wH = (WHITE,HORSE)
wB = (WHITE,BISHOP)
wR = (WHITE,ROOK)
wQ = (WHITE,QUEEN)
wK = (WHITE,KING)
wF = (WHITE,FLAG)
bP = (BLACK,PAWN)
bH = (BLACK,HORSE)
bB = (BLACK,BISHOP)
bR = (BLACK,ROOK)
bQ = (BLACK,QUEEN)
bK = (BLACK,KING)
bF = (BLACK,FLAG)

ee = (EMPTY,EMPTY)
oo = (OUT,OUT)

# начальная позиция
#                      a   b   c   d   e   f   g   h   i   j   k
StartPos =  [ oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo,
              oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo,
              oo, oo, ee, ee, ee, ee, bR, bF, bR, ee, ee, ee, ee, oo, oo, # 11
              oo, oo, ee, ee, ee, ee, bB, bQ, bB, ee, ee, ee, ee, oo, oo, # 10
              oo, oo, bP, bP, bP, ee, bH, bK, bH, ee, bP, bP, bP, oo, oo, #  9
              oo, oo, bP, bP, bP, ee, ee, ee, ee, ee, bP, bP, bP, oo, oo, #  8
              oo, oo, ee, ee, ee, oo, oo, oo, oo, oo, ee, ee, ee, oo, oo, #  7
              oo, oo, ee, ee, ee, oo, oo, oo, oo, oo, ee, ee, ee, oo, oo, #  6
              oo, oo, ee, ee, ee, oo, oo, oo, oo, oo, ee, ee, ee, oo, oo, #  5
              oo, oo, wP, wP, wP, ee, ee, ee, ee, ee, wP, wP, wP, oo, oo, #  4
              oo, oo, wP, wP, wP, ee, wH, wK, wH, ee, wP, wP, wP, oo, oo, #  3
              oo, oo, ee, ee, ee, ee, wB, wQ, wB, ee, ee, ee, ee, oo, oo, #  2
              oo, oo, ee, ee, ee, ee, wR, wF, wR, ee, ee, ee, ee, oo, oo, #  1
              oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo,
              oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo, oo ]
#                      a   b   c   d   e   f   g   h   i   j   k

# индексирование позиции
a11,b11,c11,d11,e11,f11,g11,h11,i11,j11,k11 =  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 # 11
a10,b10,c10,d10,e10,f10,g10,h10,i10,j10,k10 =  47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57 # 10
a9, b9, c9, d9, e9, f9, g9, h9, i9, j9, k9  =  62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72 #  9
a8, b8, c8, d8, e8, f8, g8, h8, i8, j8, k8  =  77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87 #  8
a7, b7, c7, d7, e7, f7, g7, h7, i7, j7, k7  =  92, 93, 94, 95, 96, 97, 98, 99,100,101,102 #  7
a6, b6, c6, d6, e6, f6, g6, h6, i6, j6, k6  = 107,108,109,110,111,112,113,114,115,116,117 #  6
a5, b5, c5, d5, e5, f5, g5, h5, i5, j5, k5  = 122,123,124,125,126,127,128,129,130,131,132 #  5
a4, b4, c4, d4, e4, f4, g4, h4, i4, j4, k4  = 137,138,139,140,141,142,143,144,145,146,147 #  4
a3, b3, c3, d3, e3, f3, g3, h3, i3, j3, k3  = 152,153,154,155,156,157,158,159,160,161,162 #  3
a2, b2, c2, d2, e2, f2, g2, h2, i2, j2, k2  = 167,168,169,170,171,172,173,174,175,176,177 #  2
a1, b1, c1, d1, e1, f1, g1, h1, i1, j1, k1  = 182,183,184,185,186,187,188,189,190,191,192 #  1
#                                              a   b   c   d   e   f   g   h   i   j   k
# списки фигур - начальная позиция
wStartList = [f2,e2,g2,e1,g1,e3,g3,f3,a4,b4,c4,i4,j4,k4,a3,b3,c3,i3,j3,k3,f1]
bStartList = [f10,e10,g10,e11,g11,e9,g9,f9,a8,b8,c8,i8,j8,k8,a9,b9,c9,i9,j9,k9,f11]

# текущая позиция
board = StartPos[:]
wList = wStartList[:]
bList = bStartList[:]
fList = [wList,bList]
# =============================================================================
def getCol(i): # возвращает цвет в позиции i
    return board[i][0]

def getTyp(i): # возвращает тип в позиции i
    return board[i][1]

def stranger(i, color): # противник на поле i
    col = getCol(i)
    if (col == EMPTY) or (col == OUT): return False
    if col != color: return True
    if col == color: return False
# =============================================================================
def weight(color): # возвращает вес фигур цвета color
    w = 0
    for i in fList[color]:
        fig = getTyp(i)
        w = w + WFIG[fig]
    return w

ecount = 0 # счетчик позиций
def evaluate(): # возвращает оценку позиции */
   global ecount
   ecount = ecount + 1
   e = weight(WHITE) - weight(BLACK)
   return e
# =============================================================================
SdList    = [] # список смещений
SdListLen = 0  # длина списка смещений
SiList    = 0  # индекс по списку смещений
Sfrom     = 0  # откуда ход
Scolor    = 0  # цвет ходящей фигуры
SiLine    = 0  # индекс по линии для дальнобойных фигур
nextMove  = []

def nextMoveQRB(): # возвращает следующий ход для ферзя, ладьи и слона
    global SdList, SdListLen, SiList, Sfrom, Scolor, SiLine
    while True:
        if SiList == SdListLen:
            return []
        if SiLine == 0:
            SiLine = Sfrom
        while True:
            SiLine =  SiLine + SdList[SiList]
            col = getCol(SiLine)
            if col == EMPTY:
                return Sfrom, SiLine
            if  col == (not Scolor):
                to = SiLine
                SiLine = 0
                SiList = SiList + 1
                return Sfrom, to
            if  col == OUT:
                SiLine = 0
                break
            if  col == Scolor:
                SiLine = 0
                break
        SiList = SiList + 1

def nextMoveKH(): # возвращает следующий ход для коня и короля
    global SdList, SdListLen, SiList, Sfrom, Scolor
    while True:
        if SiList == SdListLen:
            return []
        to = Sfrom + SdList[SiList]
        col = getCol(to)
        if (col == EMPTY) or (col == (not Scolor)):
            SiList = SiList + 1
            return Sfrom, to
        SiList = SiList + 1

def nextMoveP(): # возвращает следующий ход для пешки
    global SdList, SiList, Sfrom, Scolor
    if (SiList == 0):
        if Scolor == WHITE:
            SdList = SdList[WHITE]
        else:
            SdList = SdList[BLACK]
    while True:
        if SiList == 3:
            return []
        to = Sfrom + SdList[SiList]
        col = getCol(to)
        if SiList == 0:
            if stranger(to, Scolor):
                SiList = SiList + 1
                return Sfrom, to
        elif col == EMPTY:
            SiList = SiList + 1
            return  Sfrom, to
        SiList = SiList + 1

def nextMoveF(): return [] # флаг неподвижен
# =============================================================================
vectNextMove = (0,nextMoveP,nextMoveKH,nextMoveQRB,nextMoveQRB,nextMoveQRB,nextMoveKH,nextMoveF)

def setNextMove(i): # собраться на поиск
    global SdList,SdListLen,SiList,Sfrom,Scolor,SiLine,nextMove
    fig = getTyp(i)
    SdList = vectDisp[fig]
    SdListLen = len(SdList)
    SiList = 0
    Sfrom = i
    Scolor = getCol(i)
    SiLine = 0
    nextMove = vectNextMove[fig]

conversion = []
# превращает пешку в ферзя, информацию о превращении оставляет в conversion
def convert2Queen(fig,iFrom,iTo):
    if (fig[1] == PAWN):
        if iTo in (32,33,34,35,36,37,38,39,40,41,42,182,183,184,185,186,187,188,189,190,191,192):
            conversion.append((iFrom,iTo))
            col = fig[0]
            q = (col,QUEEN)
            return q
    return fig

def convert2Pawn(fig,iFrom,iTo): # превращает ферзя в пешку
    if fig[1] != QUEEN: return fig
    if len(conversion) == 0: return fig
    if (iFrom,iTo) == conversion[0]:
        x = conversion.pop()
        col = fig[0]
        p = (col,PAWN)
        return p
    return fig

def make(move): # сделать ход
    iFrom = move[0]
    iTo   = move[1]
    fig   = board[iFrom]
    fig   = convert2Queen(fig,iFrom,iTo)
    eat   = board[iTo]
    board[iTo] = fig
    board[iFrom] = ee
    colFig = fig[0]
    indF = fList[colFig].index(iFrom)
    fList[colFig][indF] = iTo
    colEat = eat[0]
    if colEat != EMPTY:
        indT = fList[colEat].index(iTo)
        del fList[colEat][indT]
        return (iFrom,iTo,fig,eat,indF,indT)
    return (iFrom,iTo,fig,eat,indF)

def restore(undo): # восстановить позицию
    iFrom = undo[0]
    iTo   = undo[1]
    fig   = undo[2]
    fig   = convert2Pawn(fig,iFrom,iTo)
    eat   = undo[3]
    indF  = undo[4]
    board[iTo] = eat
    board[iFrom] = fig
    colFig = fig[0]
    fList[colFig][indF] = iFrom
    colEat = eat[0]
    if colEat != EMPTY:
        indT  = undo[5]
        fList[eat[0]].insert(indT,iTo)

def rating(move): # возвращает рейтинг хода
    eat = getTyp(move[1])
    if eat == EMPTY: return 0
    fig = getTyp(move[0])
    if eat == fig: return 1
    return abs(WFIG[eat] - WFIG[fig])

# возвращает список возможных ходов отсортированный по рейтингу
def generateSortMoveList(color):
    global SdList,SdListLen,SiList,Sfrom,Scolor,SiLine,nextMove
    mList = []
    r = 0
    for i in fList[color]:
        setNextMove(i)
        move = nextMove()
        while move != []:
            r = rating(move)
            item = (r,move)
            mList.append(item)
            move = nextMove()
    mList.sort()
    mList.reverse()
    return mList       

def AlfaBeta(color, depth, alfa, beta): # альфа-бета поиск
    score = -INFINITY
    if depth <= 0: return evaluate()
    mList = generateSortMoveList(color)
    for move in mList:
        if alfa >= beta: return alfa
        undo = make(move[1])
        tmp = -AlfaBeta(not color, depth-1, -beta, -alfa)
        restore(undo)
        if tmp > score: score = tmp
        if score > alfa: alfa = score
    return score

def curtail(scoreMoves): # обрезать хвост
    if len(scoreMoves) == 1: return scoreMoves
    hs = scoreMoves[0][0]
    i = 1
    for i in range(1,len(scoreMoves),1):
        if scoreMoves[i][0] != hs: break
        i = i + 1
    sm = scoreMoves[:i]
    return sm

def randomBranch(scoreMoves): # любая ветка
    n = len(scoreMoves)
    i = randrange(0,n,1)
    return scoreMoves[i]

def search(): # поиск хода
    global side,ecount
    ecount = 0
    scoreMoves = []
    mList = generateSortMoveList(side)
    for move in mList:
        undo = make(move[1])
        if side == WHITE:
            tmp = AlfaBeta(not side, maxDepth,-INFINITY,INFINITY)
        else:
            tmp = -AlfaBeta(not side, maxDepth,-INFINITY,INFINITY)
        restore(undo)
        scoreMoves.append((tmp,move[1]))
    scoreMoves.sort()
    scoreMoves.reverse()
    scoreMoves = curtail(scoreMoves)
    return (scoreMoves)

def Box(i):
    figures = [PAWN,HORSE,BISHOP,ROOK,QUEEN,KING,FLAG]
#  letters = "pzbrqkf"
    lettersB = ["♙ ","♘ ","♗ ","♖ ","♕ ","♔ ","⚐ "]
    lettersW = ["♟ ","♞ ","♝ ","♜ ","♛ ","♚ ","⚑ "]
    col = getCol(i)
    if col == EMPTY:
        return ". "
    if col == OUT:
#        return "- "
        return "░ "
# ░
    fig = getTyp(i)  
    i = figures.index(fig)
    if col == WHITE:
        s = lettersW[i]
    else:
        s = lettersB[i]
#  if col == WHITE:
#      s = s.upper()
#     s = s + " "
    return  s

def printLine(i,n):
    ss = " "
    for k in range(n):
        ss = ss + Box(i+k)
    print ss, 

def show():
    row = 11
    x = (32,47,62,77,92,107,122,137,152,167,182)
    print "   a b c d e f g h i j k"
    for i in x:
        print " ",
        printLine(i,11)
        print row
        row = row - 1
    print "   a b c d e f g h i j k"
    print "_______________________________\n"

def ind2coor(ind):
    col = ind%15 - 1
    row = 13 - ind//15
    return col, row

def printMove(move):
    s = "-abcdefghijk"
    col, row = ind2coor(move[0])
    col1, row1 = ind2coor(move[1])
    s1 = s[col] + str(row) + "-" + s[col1] + str(row1)
    print s1
# ввод ==============================================================
tDm = (a11,b11,c11,d11,e11,f11,g11,h11,i11,j11,k11,
       a10,b10,c10,d10,e10,f10,g10,h10,i10,j10,k10,
       a9, b9, c9, d9, e9, f9, g9, h9, i9, j9, k9,
       a8, b8, c8, d8, e8, f8, g8, h8, i8, j8, k8,
       a7, b7, c7, d7, e7, f7, g7, h7, i7, j7, k7,
       a6, b6, c6, d6, e6, f6, g6, h6, i6, j6, k6,
       a5, b5, c5, d5, e5, f5, g5, h5, i5, j5, k5,
       a4, b4, c4, d4, e4, f4, g4, h4, i4, j4, k4,
       a3, b3, c3, d3, e3, f3, g3, h3, i3, j3, k3,
       a2, b2, c2, d2, e2, f2, g2, h2, i2, j2, k2,
       a1, b1, c1, d1, e1, f1, g1, h1, i1, j1, k1)

tSm = ("a11","b11","c11","d11","e11","f11","g11","h11","i11","j11","k11",
       "a10","b10","c10","d10","e10","f10","g10","h10","i10","j10","k10",
       "a9", "b9", "c9", "d9", "e9", "f9", "g9", "h9", "i9", "j9", "k9",
       "a8", "b8", "c8", "d8", "e8", "f8", "g8", "h8", "i8", "j8", "k8",
       "a7", "b7", "c7", "d7", "e7", "f7", "g7", "h7", "i7", "j7", "k7",
       "a6", "b6", "c6", "d6", "e6", "f6", "g6", "h6", "i6", "j6", "k6",
       "a5", "b5", "c5", "d5", "e5", "f5", "g5", "h5", "i5", "j5", "k5",
       "a4", "b4", "c4", "d4", "e4", "f4", "g4", "h4", "i4", "j4", "k4",
       "a3", "b3", "c3", "d3", "e3", "f3", "g3", "h3", "i3", "j3", "k3",
       "a2", "b2", "c2", "d2", "e2", "f2", "g2", "h2", "i2", "j2", "k2",
       "a1", "b1", "c1", "d1", "e1", "f1", "g1", "h1", "i1", "j1", "k1")

def s2m(s):
    for i in range(len(tSm)):
        if s == tSm[i]: return tDm[i]
    return -1

LOCK = (("LDLD",2),("LDDLD",3),("LDLDD",2),("LDDLDD",3))

def key2lock(key):
    for i in range(len(LOCK)):
        if key == LOCK[i][0]: return LOCK[i][1]
    return 0

def createKey(s):
    letter = "abcdefghijk"
    digit  = "1234567890"
    key = ""
    for i in range(len(s)):
        if s[i] in letter:
            key = key + "L"
        elif s[i] in digit:
            key = key + "D"
    return key

def goodInput(side,iFrom,iTo):
    mList = generateSortMoveList(side)
    for x in mList:
        if (iFrom,iTo) == x[1]:
            return True
    return False

def inputError(s):
    print "Illegal move:",
    print s

def getMove(): # получить ход
    key = ""
    while True:
        print ":",
        s = raw_input()
        s = s.strip()
        s = s.lower()
        if s == "go": return s
        key = createKey(s)
        d = key2lock(key)
        if d != 0:
            iFrom = s2m(s[:d])
            iTo   = s2m(s[d:])
            if ((iFrom != -1) and (iTo != -1)):
                if goodInput(side,iFrom,iTo):
                    return [iFrom,iTo]
        else:
            inputError(s)
# =============================================================================
def new(): # новая игра
    global board, wList, bList, fList, countMoves, side
    board = StartPos[:]
    wList = wStartList[:]
    bList = bStartList[:]
    fList = [wList,bList]
    countMoves = 0
    side = WHITE

def go():
    global side, ecount, countMoves
    if side == WHITE:
        print "White(",
    else:
        print "Black(",
    print countMoves, "):",
    print "Thinking..."
    scoreMoves = search()
    moveComp = randomBranch(scoreMoves)
    undo = make(moveComp[1])
    side = not side
    print "Count of positions =", ecount
    print "Rating of move =", moveComp[0]
    print "My move is:",
    printMove(moveComp[1])
    print
    show()

def makeGo():
    global side, ecount, countMoves
    if side == WHITE:
        print "White(",
    else:
        print "Black(",
    print countMoves, "):",
    print "Thinking..."
    scoreMoves = search()
    moveComp = randomBranch(scoreMoves)
    u = make(moveComp[1])
    side = not side
    print "Count of positions =", ecount
    print "Rating of move =", moveComp[0]
    print "My move is:",
    printMove(moveComp[1])
    print

def do(move):
    global side
    u = make(move)
    side = not side
    show()

def makeMove():
    global side
    move = getMove()
    print
    if move != "go":
        u = make(move)
        side = not side

def endGame():
    if getCol(f11) == WHITE:
        print "White wins"
        return True
    if getCol(f1) == BLACK:
        print "Black wins"
        return True
    return False

def game():
    global countMoves, side
    show()
    while True:
        if side == WHITE:
            print "White(",
        else:
            print "Black(",
        print countMoves, ")",
        makeMove()
        show()
        if endGame() == True: break
        makeGo()
        show()
        if endGame() == True: break            
        countMoves = countMoves + 1
    s = raw_input()

game()


