#!/bin/bash
##
#
# Support ubuntu 10.04
# Support firefox
#
#

DEBUG_LOG="/var/log/beeline_cdrom_debug.txt"

sleep $1

#detect cdrom 
for i in $(seq 0 10)
do

SCSI_SERIAL=`dmesg | tail | grep -r "Virtual  CD-ROM" | cut -d " " -f 3`
CDROM_NOD=`dmesg | tail | grep -r "$SCSI_SERIAL Attached scsi CD-ROM" | cut -d " " -f 7`

if [ "$SCSI_SERIAL" = "" ]; then
  echo "SCSI_SERIAL is empty" >> $DEBUG_LOG
  sleep 2
else
  echo "SCSI_SERIAL is not empty" >> $DEBUG_LOG
  break
fi

done

dmesg | tail >> $DEBUG_LOG
echo "$SCSI_SERIAL" >> $DEBUG_LOG
echo "$CDROM_NOD" >> $DEBUG_LOG

#waiting for /dev/sr* 
for i in $(seq 0 10)
do
  sleep 2

if [ -e "/dev/$CDROM_NOD" ] && [ "$CDROM_NOD" != "" ]; then
  echo "/dev/$CDROM_NOD exist" >> $DEBUG_LOG
  /usr/bin/eject $CDROM_NOD 2>> $DEBUG_LOG
  exit
else
  echo "/dev/$CDROM_NOD not exist" >> $DEBUG_LOG
fi

done


exit
